-- pick the right player or DIE!!
local Player = ...;
assert(Player);

local difficultyFrames = {
	Difficulty_Beginner	= 0,
	Difficulty_Easy		= 1,
	Difficulty_Medium		= 2,
	Difficulty_Hard		= 3,
	Difficulty_Challenge	= 4,
	Difficulty_Edit		= 5,
};

local frameXOffset = Player == PLAYER_2 and -16 or 16;

local function set(self, player)
	if player and player ~= Player then return end
	local SongOrCourse = nil;
	local StepsOrTrail = nil;
	if GAMESTATE:IsCourseMode() then
		SongOrCourse = GAMESTATE:GetCurrentCourse();
		StepsOrTrail = GAMESTATE:GetCurrentTrail(player);
	else
		SongOrCourse = GAMESTATE:GetCurrentSong();
		StepsOrTrail = GAMESTATE:GetCurrentSteps(player);
	end;
	if SongOrCourse and StepsOrTrail then
		local dc = StepsOrTrail:GetDifficulty()
		self:SetFromDifficulty( dc );
	else
		self:Unset();
	end

end

local t = Def.ActorFrame{
	BeginCommand=cmd(player,Player);
	PlayerJoinedMessageCommand=function(self,param)
		if param.Player == Player then
			self:visible(true);
		end;
	end;
	PlayerUnjoinedMessageCommand=function(self,param)
		if param.Player == Player then
			self:visible(false);
		end;
	end;
	Def.DifficultyIcon {
		File="_icons";
		InitCommand=function(self)
			self:SetPlayer( Player );
			self:hide_if(not GAMESTATE:IsHumanPlayer(Player));
		end;
		PlayerJoinedMessageCommand=function( self, param )
			if param.Player ~= Player then return end;
			self:visible( true );
			self:playcommand("Init");
		end;
		CurrentSongChangedMessageCommand=function(self) set(self, Player); end;
		CurrentCourseChangedMessageCommand=function(self) set(self, Player); end;
		CurrentStepsP1ChangedMessageCommand=function(self) set(self, PLAYER_1); end;
		CurrentStepsP2ChangedMessageCommand=function(self) set(self, PLAYER_2); end;
		CurrentTrailP1ChangedMessageCommand=function(self) set(self, PLAYER_1); end;
		CurrentTrailP2ChangedMessageCommand=function(self) set(self, PLAYER_2); end;
	};
};

return t;